﻿//////////////////////////////////////////////
// MemorySpaceAllocator.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkMemory
#include "../../Pointers/UniquePtr.h"

/// Class ------------------------------------

namespace nkMemory
{
	template <typename T>
	class MemorySpaceAllocator
	{
		public :

			// Destructor
			virtual ~MemorySpaceAllocator () = default ;

			// Implementation
			virtual UniquePtr<T> allocate (unsigned long long size) = 0 ;
	} ;
}